/*
 * (c) 2015 Mechatronik Karl Zeilhofer
 * karl@zeilhofer.co.at
 *
 * If you want to use or modify the sourcecode, please contact me.
 */

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QFileDialog>
#include <qdebug.h>
#include <QProcess>
#include <QProgressBar>
#include <QMessageBox>
#include <QDesktopServices>
#include <QSettings>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    restorer = new Restorer();
    restorer->moveToThread(&workerThread);

    connect(&workerThread, &QThread::finished, restorer, &QObject::deleteLater);
    connect(this, MainWindow::operate, restorer, &Restorer::process);
    connect(restorer, &Restorer::finished, this, &MainWindow::finished);
    connect(restorer, &Restorer::currentFileNameChanged, this, &MainWindow::updateFileName);
    workerThread.start();

    ui->label_currentFile->setText("");
    setWindowTitle("Windows File-History Recovery Tool V1.0");

    QSettings set;

    ui->lineEdit_sourcePath->setText(set.value("recentSourceDirectory", "C:\\").toString());
}

MainWindow::~MainWindow()
{
    workerThread.quit();
    workerThread.wait();

    QSettings set;
    set.setValue("recentSourceDirectory", ui->lineEdit_sourcePath->text());

    delete ui;
}

void MainWindow::finished()
{
    ui->pushButton_start->setEnabled(true);
    ui->pushButton_start->setText("Start");
    ui->label_currentFile->setText("finished");
}

void MainWindow::updateFileName(QString fn)
{
    ui->label_currentFile->setText(fn);
    repaint();
}

void MainWindow::on_pushButton_sourcePath_clicked()
{
    QString path = QFileDialog::getExistingDirectory(this,"Choose Root Folder to be processed", ui->lineEdit_sourcePath->text());
    if(!path.isEmpty()){
        ui->lineEdit_sourcePath->setText(path);
    }
}

void MainWindow::on_pushButton_start_clicked()
{
    ui->pushButton_start->setEnabled(false);
    ui->pushButton_start->setText("Please Wait");
    emit operate(ui->lineEdit_sourcePath->text());
}

void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, "Windows File-History Recovery Tool V1.0", "(c) 2015 by Mechatronik Karl Zeilhofer\nwww.zeilhofer.co.at");
}

void MainWindow::on_actionOnlineHelp_triggered()
{
    QString link("http://www.zeilhofer.co.at/official/doku.php?id=win_file_recorvery/");
    QDesktopServices::openUrl(QUrl(link));
}

void MainWindow::on_actionAbout_Qt_triggered()
{
    QMessageBox::aboutQt(this);
}
